/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util;

import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3341;

public final class AreaUtil {
    private AreaUtil() {
    }

    public static double distance(class_2338 a, class_2338 b) {
        return Math.sqrt(Math.pow(b.method_10263() - a.method_10263(), 2.0) + Math.pow(b.method_10264() - a.method_10264(), 2.0) + Math.pow(b.method_10260() - a.method_10260(), 2.0));
    }

    public static int distanceManhattan(class_2338 a, class_2338 b) {
        return Math.abs(b.method_10263() - a.method_10263()) + Math.abs(b.method_10264() - a.method_10264()) + Math.abs(b.method_10260() - a.method_10260());
    }

    public static double length(class_2338 a) {
        return Math.sqrt(Math.pow(a.method_10263(), 2.0) + Math.pow(a.method_10264(), 2.0) + Math.pow(a.method_10260(), 2.0));
    }

    public static String blockPosStr(class_2338 pos) {
        return new StringJoiner(", ", "[", "]").add(String.valueOf(pos.method_10263())).add(String.valueOf(pos.method_10264())).add(String.valueOf(pos.method_10260())).toString();
    }

    public static class_2338 getLowerPos(class_2338 pos1, class_2338 pos2) {
        return pos1.method_10260() < pos2.method_10260() ? pos1 : pos2;
    }

    public static class_2338 getHigherPos(class_2338 pos1, class_2338 pos2) {
        return pos1.method_10260() > pos2.method_10260() ? pos1 : pos2;
    }

    public static Set<class_2338> getBoundingBoxFrame(class_3341 box) {
        class_2338[] corners = new class_2338[]{new class_2338(box.method_35415(), box.method_35416(), box.method_35417()), new class_2338(box.method_35415(), box.method_35416(), box.method_35420()), new class_2338(box.method_35415(), box.method_35419(), box.method_35417()), new class_2338(box.method_35415(), box.method_35419(), box.method_35420()), new class_2338(box.method_35418(), box.method_35416(), box.method_35417()), new class_2338(box.method_35418(), box.method_35416(), box.method_35420()), new class_2338(box.method_35418(), box.method_35419(), box.method_35417()), new class_2338(box.method_35418(), box.method_35419(), box.method_35420())};
        int[][] edgePairs = new int[][]{{0, 1}, {0, 2}, {0, 4}, {1, 3}, {1, 5}, {2, 3}, {2, 6}, {3, 7}, {4, 5}, {4, 6}, {5, 7}, {6, 7}};
        HashSet<class_2338> frame = new HashSet<class_2338>();
        for (int[] pair : edgePairs) {
            frame.addAll(AreaUtil.getEdge(corners[pair[0]], corners[pair[1]]));
        }
        return frame;
    }

    public static Set<class_2338> getEdge(class_2338 a, class_2338 b) {
        HashSet<class_2338> result = new HashSet<class_2338>();
        int dx = Integer.compare(b.method_10263(), a.method_10263());
        int dy = Integer.compare(b.method_10264(), a.method_10264());
        int dz = Integer.compare(b.method_10260(), a.method_10260());
        class_2338 current = a;
        result.add(current);
        while (!current.equals((Object)b)) {
            current = current.method_10069(dx, dy, dz);
            result.add(current);
        }
        return result;
    }

    public static Set<class_2338> blocksBetweenOnAxis(class_2338 p1, class_2338 p2, class_2350.class_2351 axis) {
        class_3341 blockLine = class_3341.method_34390((class_2382)p1, (class_2382)p2);
        HashSet<class_2338> blocks = new HashSet<class_2338>();
        switch (axis) {
            case field_11048: {
                for (int x = blockLine.method_35415(); x <= blockLine.method_35418(); ++x) {
                    blocks.add(new class_2338(x, p1.method_10264(), p1.method_10260()));
                }
                break;
            }
            case field_11052: {
                for (int y = blockLine.method_35416(); y <= blockLine.method_35419(); ++y) {
                    blocks.add(new class_2338(p1.method_10263(), y, p1.method_10260()));
                }
                break;
            }
            case field_11051: {
                for (int z = blockLine.method_35417(); z <= blockLine.method_35420(); ++z) {
                    blocks.add(new class_2338(p1.method_10263(), p1.method_10264(), z));
                }
                break;
            }
        }
        return blocks;
    }

    public static Set<class_2338> blocksIn(class_3341 cube) {
        HashSet<class_2338> blocks = new HashSet<class_2338>();
        for (int x = cube.method_35415(); x <= cube.method_35418(); ++x) {
            for (int y = cube.method_35416(); y <= cube.method_35419(); ++y) {
                for (int z = cube.method_35417(); z <= cube.method_35420(); ++z) {
                    blocks.add(new class_2338(x, y, z));
                }
            }
        }
        return blocks;
    }

    public static Set<class_2338> blocksIn(class_3341 cube, Predicate<class_2338> inclusion) {
        HashSet<class_2338> blocks = new HashSet<class_2338>();
        for (int x = cube.method_35415(); x <= cube.method_35418(); ++x) {
            for (int y = cube.method_35416(); y <= cube.method_35419(); ++y) {
                for (int z = cube.method_35417(); z <= cube.method_35420(); ++z) {
                    class_2338 blockPos = new class_2338(x, y, z);
                    if (!inclusion.test(blockPos)) continue;
                    blocks.add(blockPos);
                }
            }
        }
        return blocks;
    }

    public static int blocksOnAxis(class_3341 box, class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048: {
                return box.method_35414();
            }
            case field_11052: {
                return box.method_14660();
            }
            case field_11051: {
                return box.method_14663();
            }
        }
        throw new IllegalArgumentException();
    }

    public static class_3341 getSlice(class_2338 center, int halfSize, int offset, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> {
                class_2338 p1 = center.method_10069(halfSize, halfSize, offset);
                class_2338 p2 = center.method_10069(-halfSize, -halfSize, offset);
                yield class_3341.method_34390((class_2382)p1, (class_2382)p2);
            }
            case class_2350.class_2351.field_11052 -> {
                class_2338 p1 = center.method_10069(halfSize, offset, halfSize);
                class_2338 p2 = center.method_10069(-halfSize, offset, -halfSize);
                yield class_3341.method_34390((class_2382)p1, (class_2382)p2);
            }
            case class_2350.class_2351.field_11051 -> {
                class_2338 p1 = center.method_10069(offset, halfSize, halfSize);
                class_2338 p2 = center.method_10069(offset, -halfSize, -halfSize);
                yield class_3341.method_34390((class_2382)p1, (class_2382)p2);
            }
        };
    }

    public static Set<class_2338> getSliceBlocks(class_2338 center, int halfSize, int offset, class_2350.class_2351 axis, Predicate<class_2338> include) {
        class_3341 slice = AreaUtil.getSlice(center, halfSize, offset, axis);
        return AreaUtil.blocksIn(slice, include);
    }
}

